// background.js (Firefox / WebExtensions)

browser.runtime.onInstalled.addListener(() => {
    browser.contextMenus.create({
        id: "googleIndexedPagesParent",
        title: "indexed pages Firefox Mozilla",
        contexts: ["all"]
    });

    const timeFilters = [
        { id: "anyTime", title: "Any time" },
        { id: "pastHour", title: "Past hour" },
        { id: "past24Hours", title: "Past 24 hours" },
        { id: "pastWeek", title: "Past week" },
        { id: "pastMonth", title: "Past month" },
        { id: "pastYear", title: "Past year" }
    ];

    timeFilters.forEach((filter) => {
        browser.contextMenus.create({
            id: filter.id,
            parentId: "googleIndexedPagesParent",
            title: filter.title,
            contexts: ["all"]
        });
    });

    browser.contextMenus.create({
        id: "googleIndexAndWhois",
        title: "Google index and whois?",
        contexts: ["all"]
    });
});

browser.contextMenus.onClicked.addListener(async (info, tab) => {
    let domain = "";
    try {
        const res = await browser.tabs.executeScript(tab.id, {
            code: "window.__lastRightClickDomain || '';"
        });
        domain = (res && res[0]) || "";
    } catch (e) { }

    let finalDomain = domain;

    const DOMAIN_REGEX = /^([a-z0-9-]+\.)+[a-z]{2,}$/i;

    if (!finalDomain || !DOMAIN_REGEX.test(finalDomain)) {
        try {
            const host = new URL(tab.url).hostname.replace(/^www\./, "");
            if (DOMAIN_REGEX.test(host)) finalDomain = host;
        } catch (e) { }
    }

    if (!finalDomain || !DOMAIN_REGEX.test(finalDomain)) {
        try {
            await browser.tabs.executeScript(tab.id, {
                code: "alert('Please select a valid domain in the sheet or on the page.');"
            });
        } catch (e) { }
        return;
    }

    const timeTbsMap = {
        anyTime: "",
        pastHour: "qdr:h",
        past24Hours: "qdr:d",
        pastWeek: "qdr:w",
        pastMonth: "qdr:m",
        pastYear: "qdr:y"
    };

    if (info.menuItemId in timeTbsMap) {
        const tbs = timeTbsMap[info.menuItemId];
        const url = `https://www.google.com/search?q=site:${finalDomain}${tbs ? `&tbs=${tbs}` : ""}`;
        browser.tabs.create({ url, active: true });
        return;
    }

    if (info.menuItemId === "googleIndexAndWhois") {
        browser.tabs.create({ url: `https://www.google.com/search?q=site:${finalDomain}`, active: true });
        browser.tabs.create({ url: `https://www.whois.com/whois/${finalDomain}`, active: false });
    }
});
